/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _SURFACESETNATIVECONTENTCOMMAND_H_
#define _SURFACESETNATIVECONTENTCOMMAND_H_

#include "ICommand.h"
#include "PixelFormat.h"
#include "IScene.h"

class SurfaceSetNativeContentCommand : public ICommand
{
public:
    /*!
     * \action    This command sets the native content (application content)
     *            of a surface within the GENIVI LayerManagement
     * \frequency Typically once during startup of an application providing content
     *            for a surface.
     * \param[in] sender process id of application that sent this command
     * \param[in] surfaceId id of surface
     * \param[in] handle
     * \param[in] pixelformat
     * \param[in] OriginalWidth
     * \param[in] OriginalHeight original height for native content
     * \ingroup Commands
     */
    SurfaceSetNativeContentCommand(pid_t sender,
                                    unsigned int surfaceId,
                                    unsigned int handle,
                                    PixelFormat pixelformat,
                                    uint OriginalWidth,
                                    uint OriginalHeight)
    : ICommand(ExecuteSynchronous, sender)
    , m_surfaceId(surfaceId)
    , m_nativeHandle(handle)
    , m_pixelformat(pixelformat)
    , m_originalWidth(OriginalWidth)
    , m_originalHeight(OriginalHeight)
    {}

    /**
     * \brief default destructor
     */
    virtual ~SurfaceSetNativeContentCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    uint m_surfaceId;
    const unsigned int m_nativeHandle;
    const PixelFormat m_pixelformat;
    uint m_originalWidth;
    uint m_originalHeight;

    // for unit testing
    //template <typename nativeHandle_type, typename pixelformat_type, typename OriginalWidth_type,
    //      typename OriginalHeight_type> friend class SurfaceSetRenderBufferCommandEqMatcherP4;
};


#endif /* _SURFACESETNATIVECONTENTCOMMAND_H_ */
